<%@ LANGUAGE="VBScript" %>

<% '***************************************************************************
   '* ASP Football Pool                                                       *
   '*                                                                         *
   '* Copyright 2000 by Mike Hall                                             *
   '* Please see http://www.brainjar.com for documentation and terms of use.  *
   '***************************************************************************
%>

<!-- #include file="protect.inc" -->
<!-- #include file="common.inc" -->
<!-- #include file="header.inc" -->

<% 'Open the database.

   call OpenDB()

   'Default to current week if no valid number was given.

   week = Request("week")
   if not IsNumeric(week) then
     week = CurrentWeek()
   else
     week = Round(week)
     if week < 1 or week > NumberOfWeeks() then
       week = CurrentWeek()
     end if
   end if

   'Initialize global lock out variable.

   dateNow = CurrentDateTime()
   allLocked = false

   'Create an array of game objects

   dim games
   n = NumberOfGames(week)
   redim games(n - 1)

   sql = "select Schedule.*," _
      & " Teams.City as VCity, Teams.Name as VName, Teams.DisplayName as VDisplayName," _
      & " Teams2.City as HCity, Teams2.Name as HName, Teams2.DisplayName as HDisplayName" _
      & " from (Schedule inner join Teams on Schedule.VisitorID = Teams.TeamID)" _
      & " inner join Teams as Teams2 on Schedule.HomeID = Teams2.TeamID" _
      & " where Schedule.Week = " & week _
      & " order by Schedule.Date, Schedule.Time, Teams.City, Teams.Name"
   set rs = DbConn.Execute(sql)
   if not (rs.BOF and rs.EOF) then
     i = 0
     do while not rs.EOF
       set games(i) = new GameObj
       games(i).setData(rs)
       i = i + 1
       rs.MoveNext
     loop
   end if

   'If there's form data, check it.

   errorFlag = false
   if Request.ServerVariables("Content_Length") > 0 then
     tb = Request.Form("tb")

     'Administrator may not make entries.

     if Session("PoolUsername") = ADMIN_USERNAME then
       call ErrorMessage("User '" & ADMIN_USERNAME & "' may not enter picks.")
       errorFlag = true

     'If all games locked, no changes allowed.

     elseif allLocked then
       call ErrorMessage("All games for this week have been locked out, changes not accepted.")
       errorFlag = true

     'Check tie breaker value.

     else
       if tb = "" then
         call ErrorMessage("You must enter a point total for the tie breaker, changes not accepted.")
         errorFlag = true
       elseif not IsNumeric(tb) then
         call ErrorMessage("Tie breaker point total must be numeric, changes not accepted.")
         errorFlag = true
       elseif tb < 0 or CDbl(tb) <> Round(CDbl(tb)) then
         call ErrorMessage("Invalid tie breaker point value, changes not accepted.")
         errorFlag = true
       end if

     end if

     'Check for picks in locked out games

     if not allLocked then
       anyLocked = false
       for i = 0 to UBound(games)
         if Request.Form("pick-" & games(i).id) <> "" and games(i).isLocked then
           call ErrorMessage(games(i).visitorName & " at " & games(i).homeName _
             & " has been locked, this change not accepted.")
           errorFlag = true
           anyLocked = true
         end if
       next
       if anyLocked then
         call ErrorMessage("Please resubmit to update remaining picks.")
       end if
     end if

     'If there were no errors, process the data and redirect the user to the
     'results page.

     if not errorFlag then
       for i = 0 to UBound(games)
         pick = Request.Form("pick-" & games(i).id)
         if pick = "" then
           pick = GetPick(games(i).id)
         end if
         sql = "delete from Picks" _
            & " where Username = '" & Session("PoolUsername") & "'" _
            & " and GameID = " & games(i).id
         set rs = DbConn.Execute(sql)
         sql = "insert into Picks" _
            & " (Username, GameID, Pick)" _
            & " values('" & Session("PoolUsername") & "'," _
            & " '" & games(i).id & "', " _
            & " '" & pick & "')"
         set rs = DbConn.Execute(sql)
       next
       if tb <> "" then
         sql = "delete from TieBreaker" _
            & " where Week = " & week _
            & " and Username = '" & Session("PoolUsername") & "'"
         set rs = DbConn.Execute(sql)   
         sql = "insert into TieBreaker" _
            & " (Week, Username, TBPoints)" _
            & " values(" & week & ", '" & Session("PoolUsername") & "'," _
            & " " & tb & ")"
         set rs = DbConn.Execute(sql)
       end if
       Response.Redirect("results.asp?week=" & week)
     end if

   end if

   'Build the form. %>

<form action="<% = Request.ServerVariables("SCRIPT_NAME") %>" method="post">
<input name="week" type="hidden" value="<% = week %>">
<p><table class="formatted" cellpadding=0 cellspacing=0>
<tr><th colspan=9>Week <% = week %></th></tr>
<% for i = 0 to UBound(games)
     if Round(i / 2) * 2 = i then %>
<tr align=right>
<%   else %>
<tr align=right class="alt">
<%   end if %>
  <td><% = WeekdayName(Weekday(games(i).datetime), true) %>&nbsp;</td>
  <td><% = FormatDate(games(i).datetime) %>&nbsp;</td>
  <td><% = FormatTime(games(i).datetime) %>&nbsp;</td>

<%   'If no pick was given for this game or the game is locked, check the
     'database for an existing value.

      pick = Request.Form("pick-" & games(i).id)
      if pick = "" or games(i).isLocked then
        pick = GetPick(games(i).id)
      end if

     if games(i).isLocked then
       visitor = games(i).visitorName
       home = games(i).homeName
       tie = "&nbsp;"
       if pick = games(i).visitorID then
         visitor = "<b>" & visitor & "</b>"
       elseif pick = games(i).homeID then
         home = "<b>" & home & "</b>"
       elseif pick = TIE_STR then
         tie = "<b>Tie</b>"
       end if %>
  <td><% = visitor %>&nbsp;</td>
  <td>&nbsp;</td>
  <td>at <% = home %>&nbsp;</td>
  <td>&nbsp;</td>
  <td><% = tie %></td>
  <td>&nbsp;</td>
<%   else %>
  <td><% = games(i).visitorName %>&nbsp;</td>
  <td><input name="pick-<% = games(i).id %>" type="radio" value="<% = games(i).visitorID %>" <% = IsChecked(pick, games(i).visitorID) %>></td>
  <td>at <% = games(i).homeName %>&nbsp;</td>
  <td><input name="pick-<% = games(i).id %>" type="radio" value="<% = games(i).homeID %>" <% = IsChecked(pick, games(i).homeID) %>></td>
  <td>Tie</td>
  <td><input name="pick-<% = games(i).id %>" type="radio" value="<% = TIE_STR %>" <% = IsChecked(pick, TIE_STR) %>></td>
<%   end if %>
</tr>
<% next %>
<tr><th colspan=9>Tie Breaker</th></tr>
<tr>
  <td align=right colspan=9>
  Total points in the Monday Night Football game:

<% 'If no tie breaker points were given or all games have been locked, check
   'the database for an existing value.

   if tb = "" or allLocked then
     tb = UserTBGuess(Session("PoolUsername"), week)
   end if
   if allLocked then %>
  <b><% = tb %><b>
<% else %>
  <input name="tb" type="text" value="<% = tb %>" size=2>
<% end if %>
  </td>
</tr>
</table></p>

<p><input type="submit" value="Submit"></p>
</form>

<% str = OpenDates(week)
   if str <> "" then %>
<p><b>Open Dates:</b> <% = str %></p>
<% end if %>

<% 'List remaining weeks %>
<% n = NumberOfWeeks()
   week = CurrentWeek()
   if week <> n then %>
<p><b>Go to week:</b>&nbsp;
<%   for i = week to NumberOfWeeks() %>
<a href="<% = Request.ServerVariables("SCRIPT_NAME") %>?week=<% = i %>">
<% = i %></a>&nbsp;
<%   next %>
</p>
<% end if %>

<!-- #include file="footer.inc" -->

<% '***************************************************************************
   '* Local functions and subroutines.                                              *
   '***************************************************************************

   '---------------------------------------------------------------------------
   ' GetPick(id): Find this user's current pick for the given game. Returns a
   ' null string if no pick is found in the database.
   '---------------------------------------------------------------------------

   function GetPick(id)

     dim sql, rs

     GetPick = ""
     sql = "select Pick from Picks" _
        & " where Username = '" & Session("PoolUsername") & "'" _
        & " and GameID = " & id
     set rs = DbConn.Execute(sql)
     if not (rs.BOF and rs.EOF) then
       GetPick = rs.Fields("Pick").Value
     end if

   end function

   '---------------------------------------------------------------------------
   ' IsChecked(v1, v2): Used to set a radio button checked parameter if the
   ' values given are equal.
   '---------------------------------------------------------------------------

   function IsChecked(v1, v2)

     IsChecked = ""
     if v1 = v2 then
       IsChecked = " checked"
     end if

   end function

   '***************************************************************************
   '* Local class definitions.                                                      *
   '***************************************************************************

   '---------------------------------------------------------------------------
   ' GameObj: Used to hold data for a single game.
   '---------------------------------------------------------------------------

   class GameObj

     public id
     public datetime
     public visitorID
     public visitorName
     public homeID
     public homeName
     public isLocked

     private sub Class_Initialize()
     end sub

     private sub Class_Terminate()
     end sub

     public sub setData(rs)

       'Set game properties using the supplied database record.

       id          = rs.Fields("GameID").Value
       datetime    =  CDate(rs.Fields("Date").Value & " " & rs.Fields("Time").Value)
       visitorID   = rs.Fields("VisitorID").Value
       visitorName = rs.Fields("VCity").Value
       homeID      = rs.Fields("HomeID").Value
       homeName    = rs.Fields("HCity").Value
       isLocked    = false

       'Use display name for team if available.

       if rs.Fields("VDisplayName").Value <> "" then
         visitorName = rs.Fields("VDisplayName").Value
       end if
       if rs.Fields("HDisplayName").Value <> "" then
         homeName = rs.Fields("HDisplayName").Value
       end if

       'Determine game lock out status. If this is a Sunday game and it's
       'past the game's start time, set the global lock all flag.

       if Weekday(datetime) = vbSunday and datetime <= dateNow then
         allLocked = true
       end if
       if allLocked or datetime <= dateNow then
         isLocked = true
       end if

     end sub

   end class %>
